package org.eclipse.jem.tests.beaninfo.java.awt;
/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

import java.beans.*;
import org.eclipse.jem.tests.beaninfo.preq.infos.BaseBeanInfo;

public class ContainerBeanInfo extends BaseBeanInfo {
	private static java.util.ResourceBundle rescontainer = java.util.ResourceBundle.getBundle("org.eclipse.jem.tests.beaninfo.java.awt.container");  //$NON-NLS-1$
		
/**
 * Gets the containerevent set descriptor.
 * @return java.beans.EventSetDescriptor
 */
public java.beans.EventSetDescriptor containerEventSetDescriptor() {
	EventSetDescriptor aDescriptor = null;
	Class[] paramTypes = { java.awt.event.ContainerEvent.class };
	MethodDescriptor aDescriptorList[] = {
			super.createMethodDescriptor(java.awt.event.ContainerListener.class,
				"componentAdded", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, rescontainer.getString("componentAddedDN"), //$NON-NLS-1$
	      		SHORTDESCRIPTION, rescontainer.getString("componentAddedSD"), //$NON-NLS-1$
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("containerEvent", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("containerEventDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "component added event",
	      			}
	      		)
	      	},
	      	paramTypes
		  	),
		  	super.createMethodDescriptor(java.awt.event.ContainerListener.class,
				"componentRemoved", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, rescontainer.getString("componentRemovedDN"), //$NON-NLS-1$
	      		SHORTDESCRIPTION, rescontainer.getString("componentRemovedSD"), //$NON-NLS-1$
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("containerEvent", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("containerEventDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "component removed event",
	      			}
	      		)
	      	},
	      	paramTypes
		  	)
		};	
		aDescriptor = super.createEventSetDescriptor(getBeanClass(),
						"container", new Object[] {//$NON-NLS-1$
						DISPLAYNAME, rescontainer.getString("containerEventsDN"), //$NON-NLS-1$
	      				SHORTDESCRIPTION, rescontainer.getString("containerEventsSD"), //$NON-NLS-1$
	      			}, 
						aDescriptorList, java.awt.event.ContainerListener.class,
						"addContainerListener", "removeContainerListener");//$NON-NLS-2$//$NON-NLS-1$

	return aDescriptor;
}
/**
 * Gets the bean class.
 * @return java.lang.Class
 */
public Class getBeanClass() {
	return java.awt.Container.class;
}
public java.beans.BeanDescriptor getBeanDescriptor() {
	java.beans.BeanDescriptor aDescriptor = null;
	try {
		/* Create and return the ContainerBeanInfobean descriptor. */
		aDescriptor = new java.beans.BeanDescriptor(java.awt.Container.class);
		aDescriptor.setDisplayName(rescontainer.getString("ContainerDN")); //$NON-NLS-1$
		aDescriptor.setShortDescription(rescontainer.getString("ContainerSD")); //$NON-NLS-1$
	} catch (Throwable exception) {
	};
	return aDescriptor;
}
/**
 * Return the event set descriptors for this bean.
 * @return java.beans.EventSetDescriptor[]
 */
public java.beans.EventSetDescriptor[] getEventSetDescriptors() {
	try {
		java.beans.EventSetDescriptor aDescriptorList[] = {
			containerEventSetDescriptor()
		};
		return aDescriptorList;
	} catch (Throwable exception) {
		handleException(exception);
	};
	return null;
}
/**
 * Return the method descriptors for this bean.
 * @return java.beans.MethodDescriptor[]
 */
public java.beans.MethodDescriptor[] getMethodDescriptors() {
	try {
		java.beans.MethodDescriptor aDescriptorList[] = {
		   // add(Component)
			super.createMethodDescriptor(getBeanClass(), "add", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "add(Component)",//$NON-NLS-1$
	      		SHORTDESCRIPTION, rescontainer.getString("add(Component)SD"), //$NON-NLS-1$
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("comp", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("componentParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Component to add",
	      			}
	      		)
	      	},
	      	new Class[] { 
	      		java.awt.Component.class 
	      	}	    		
		  	),							
			// add(Component,int)
			super.createMethodDescriptor(getBeanClass(), "add", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "add(Component,int)",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Add the component at position",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("comp", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("componentParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Component to add",
	      			}
	      		),
	    			createParameterDescriptor("index", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("indexParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Position to add at",
	      			}
	      		)	      		
	      	},
	      	new Class[] { 
	      		java.awt.Component.class,
	      		int.class
	      	}	    		
		  	),
			// add(Component,Object,int)
			super.createMethodDescriptor(getBeanClass(), "add", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "add(Component,Object,int)",//$NON-NLS-1$
	   			EXPERT, Boolean.TRUE
	      		// SHORTDESCRIPTION, "Add the component with constraints at position",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("comp", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("componentParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Component to add",
	      			}
	      		),
	      		createParameterDescriptor("constraints", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("constraintsParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Layout constraints",
	      			}
	      		),
	    			createParameterDescriptor("index", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("indexParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Position to add at",
	      			}
	      		),	      		
	      	},
	      	new Class[] { 
	      		java.awt.Component.class,
	      		java.lang.Object.class,
	      		int.class
	      	}	    		
		  	),
			// add(Component,Object)
			super.createMethodDescriptor(getBeanClass(), "add", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "add(Component,Object)",//$NON-NLS-1$
	   			EXPERT, Boolean.TRUE
	      		// SHORTDESCRIPTION, "Add the component with constraints",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("comp", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("componentParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Component to add",
	      			}
	      		),
	    			createParameterDescriptor("constraints", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("constraintsParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Layout constraints",
	      			}
	      		)	      		
	      	},
	      	new Class[] { 
	      		java.awt.Component.class,
	      	   java.lang.Object.class
	      	}	    		
		  	),
			// add(String,Component)
			super.createMethodDescriptor(getBeanClass(), "add", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "add(String,Component)",//$NON-NLS-1$
	      		SHORTDESCRIPTION, rescontainer.getString("add(String,Component)SD"), //$NON-NLS-1$
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("name", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("constraintsParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Layout constraints",
	      			}
	      		),	    			
	    			createParameterDescriptor("comp", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("componentParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Component to add",
	      			}
	      		)	      		
	      	},
	      	new Class[] { 
	      		String.class, java.awt.Component.class
	      	}	    		
		  	),		  	
			// addNotify()
			super.createMethodDescriptor(getBeanClass(), "addNotify", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "addNotify()",//$NON-NLS-1$
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Notify component has been added",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// doLayout()
			super.createMethodDescriptor(getBeanClass(), "doLayout", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "doLayout()",//$NON-NLS-1$
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Lay out the components",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// getAlignmentX()
			super.createMethodDescriptor(getBeanClass(), "getAlignmentX", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "getAlignmentX()",//$NON-NLS-1$
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Get the alignment along x-axis",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// getAlignmentY()
			super.createMethodDescriptor(getBeanClass(), "getAlignmentY", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "getAlignmentY()",//$NON-NLS-1$
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Get the alignment along y-axis",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// getComponent(int)
			super.createMethodDescriptor(getBeanClass(), "getComponent", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "getComponent(int)",//$NON-NLS-1$
	      		SHORTDESCRIPTION, rescontainer.getString("getComponent(int)SD"), //$NON-NLS-1$
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("index", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("indexParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "index of Component to get",
	      			}
	      		)
	      	},
	      	new Class[] { 
	      		int.class 
	      	}	    		
		  	),
			// getComponentAt(int,int)
			super.createMethodDescriptor(getBeanClass(), "getComponentAt", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "getComponentAt(int,int)",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Get the component at x,y",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("x", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("xParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "x-coordinate",
	      			}
	      		),
	      		createParameterDescriptor("y", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("yParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "y-coordinate",
	      			}
	      		)
	      	},
	      	new Class[] { 
	      		int.class,
	      		int.class
	      	}	    		
		  	),
			// getComponentAt(Point)
			super.createMethodDescriptor(getBeanClass(), "getComponentAt", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "getComponentAt(Point)",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Get the component at point",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("point", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("pointParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Point contained by component",
	      			}
	      		)
	      	},
	      	new Class[] { 
	      		java.awt.Point.class 
	      	}	    		
		  	),
			// getComponentCount()
			super.createMethodDescriptor(getBeanClass(), "getComponentCount", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "getComponentCount()",//$NON-NLS-1$
	      		SHORTDESCRIPTION, rescontainer.getString("getComponentCount()SD"), //$NON-NLS-1$
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// getComponents()
		   super.createMethodDescriptor(getBeanClass(), "getComponents", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "getComponents()",//$NON-NLS-1$
	      		SHORTDESCRIPTION, rescontainer.getString("getComponents()SD"), //$NON-NLS-1$
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// getInsets()
			super.createMethodDescriptor(getBeanClass(), "getInsets", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "getInsets()",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Get the insets",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// getLayout()
			super.createMethodDescriptor(getBeanClass(), "getLayout", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "getLayout()",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Get the layout manager",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// getMaximumSize()
			super.createMethodDescriptor(getBeanClass(), "getMaximumSize", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "getMaximumSize()",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Get the maximum size",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// getMinimumSize()
			super.createMethodDescriptor(getBeanClass(), "getMinimumSize", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "getMinimumSize()",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Get the minimum size",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// getPreferredSize()
			super.createMethodDescriptor(getBeanClass(), "getPreferredSize", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "getPreferredSize()",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Get the preferred size",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// invalidate()
			super.createMethodDescriptor(getBeanClass(), "invalidate", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "invalidate()",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Invalidate container and parents",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// isAncestorOf(Component)
			super.createMethodDescriptor(getBeanClass(), "isAncestorOf", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "isAncestorOf(Component)",//$NON-NLS-1$
	      		SHORTDESCRIPTION, rescontainer.getString("isAncestorOf(Component)SD"), //$NON-NLS-1$
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("comp", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("componentPArmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Component to query",
	      			}
	      		)
	      	},
	      	new Class[] { 
	      		java.awt.Component.class 
	      	}	    		
		  	),
			// list(PrintStream,int)
			super.createMethodDescriptor(getBeanClass(), "list", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "list(PrintStream,int)",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Print listing of container to stream",
	      		EXPERT, Boolean.TRUE,
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("out", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("outParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Stream to print to",
	      			}
	      		),
	      		createParameterDescriptor("indent", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("indentParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "number of spaces to indent",
	      			}
	      		)	      		
	      	},
	      	new Class[] { 
	      		java.io.PrintStream.class,
	      		int.class
	      	}   		
		  	),
			// list(PrintWriter,int)
			super.createMethodDescriptor(getBeanClass(), "list", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "list(PrintWriter,int)",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Print listing of container to writer",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("out", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("outParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Writer to print to",
	      			}
	      		),
	      		createParameterDescriptor("indent", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("indentParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "number of spaces to indent",
	      			}
	      		)	      		
	      	},
	      	new Class[] { 
	      		java.io.PrintWriter.class,
	      		int.class
	      	}   		
		  	),
			// paint(Graphics)
			super.createMethodDescriptor(getBeanClass(), "paint", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "paint(Graphics)",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Paint this container",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("graphics", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("graphicsParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "the graphics context to use",
	      			}
	      		)	      		
	      	},
	      	new Class[] { 
	      		java.awt.Graphics.class
	      	}   		
		  	),
			// paintComponents(Graphics)
			super.createMethodDescriptor(getBeanClass(), "paint", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "paintComponents(Graphics)",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Paint the components",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("graphics", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("graphicsParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "the graphics context to use",
	      			}
	      		)	      		
	      	},
	      	new Class[] { 
	      		java.awt.Graphics.class
	      	}   		
		  	),
			// print(Graphics)
			super.createMethodDescriptor(getBeanClass(), "print", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "print(Graphics)",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Print this container",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("graphics", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("graphicsParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "the graphics context to use",
	      			}
	      		)	      		
	      	},
	      	new Class[] { 
	      		java.awt.Graphics.class
	      	}   		
		  	),
			// printComponents(Graphics)
			super.createMethodDescriptor(getBeanClass(), "print", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "printComponents(Graphics)",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Print this container's components",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("graphics", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("graphicsParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "the graphics context to use",
	      			}
	      		)	      		
	      	},
	      	new Class[] { 
	      		java.awt.Graphics.class
	      	}   		
		  	),
			// remove(int)
			super.createMethodDescriptor(getBeanClass(), "remove", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "remove(int)",//$NON-NLS-1$
	      		SHORTDESCRIPTION, rescontainer.getString("remove(int)SD"), //$NON-NLS-1$
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("index", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("indexParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Index of Component to remove",
	      			}
	      		)
	      	},
	      	new Class[] { 
	      		int.class 
	      	}	    		
		  	),
			// remove(Component)
			super.createMethodDescriptor(getBeanClass(), "remove", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "remove(Component)",//$NON-NLS-1$
	      		SHORTDESCRIPTION, rescontainer.getString("remove(Component)SD"), //$NON-NLS-1$
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("comp", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("componentParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Component to remove",
	      			}
	      		)
	      	},
	      	new Class[] { 
	      		java.awt.Component.class 
	      	}	    		
		  	),
			// removeAll()
			super.createMethodDescriptor(getBeanClass(), "removeAll", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "removeAll",//$NON-NLS-1$
	      		SHORTDESCRIPTION, rescontainer.getString("removeAll()DN"), //$NON-NLS-1$
	    		}, 
	    		new ParameterDescriptor[] {},
	      	   new Class[] {}  		
		  	),
			// removeNotify()
			super.createMethodDescriptor(getBeanClass(), "removeNotify", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "removeNotify()",//$NON-NLS-1$
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Notify to remove peers",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
			// setLayout(LayoutManager)
			super.createMethodDescriptor(getBeanClass(), "setLayout", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "setLayout(LayoutManager)",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Set the layout manager",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("mgr", new Object[] {//$NON-NLS-1$
	   				DISPLAYNAME, rescontainer.getString("layoutManagerParmDN"), //$NON-NLS-1$
	      			// SHORTDESCRIPTION, "Layout Manager",
	      			}
	      		),		      				      		
	      	},
	      	new Class[] {
	      		java.awt.LayoutManager.class, 
	      	}   		
		  	),
			// validate()
			super.createMethodDescriptor(getBeanClass(), "validate", //$NON-NLS-1$
				new Object[] {
	   			DISPLAYNAME, "validate()",//$NON-NLS-1$
	      		// SHORTDESCRIPTION, "Validate container and components",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		};
		return aDescriptorList;
	} catch (Throwable exception) {
		handleException(exception);
	};
	return null;
}
/**
 * Return the property descriptors for this bean.
 * @return java.beans.PropertyDescriptor[]
 */
public java.beans.PropertyDescriptor[] getPropertyDescriptors() {
	try {
		java.beans.PropertyDescriptor aDescriptorList[] = {
			// alignmentX  
	   	super.createPropertyDescriptor(getBeanClass(), "alignmentX", new Object[] {//$NON-NLS-1$
		   	DISPLAYNAME, rescontainer.getString("alignmentXDN"), //$NON-NLS-1$
	      	// SHORTDESCRIPTION, "Alignment along the x-axis",
	         EXPERT, Boolean.TRUE 
	    		}
		  	),
			// ,alignmentY
			super.createPropertyDescriptor(getBeanClass(), "alignmentY", new Object[] {//$NON-NLS-1$
		   	DISPLAYNAME, rescontainer.getString("alignmentYDN"), //$NON-NLS-1$
	      	// SHORTDESCRIPTION, "Alignment along the y-axis",
	      	EXPERT, Boolean.TRUE 
	    		}
	    	),
			// componentCount()
			super.createPropertyDescriptor(getBeanClass(), "componentCount", new Object[] {//$NON-NLS-1$
		   	DISPLAYNAME, rescontainer.getString("componentCountDN"),				 //$NON-NLS-1$
	      	SHORTDESCRIPTION, rescontainer.getString("componentCountSD"), //$NON-NLS-1$
	      	EXPERT, Boolean.TRUE,
	    		}
	    	),
			// components
			super.createPropertyDescriptor(getBeanClass(), "components", new Object[] {//$NON-NLS-1$
		   	DISPLAYNAME, rescontainer.getString("componentsDN"),			 //$NON-NLS-1$
	      	SHORTDESCRIPTION, rescontainer.getString("componentsSD"), //$NON-NLS-1$
	    		}
	    	),
			// insets
			super.createPropertyDescriptor(getBeanClass(), "insets", new Object[] {//$NON-NLS-1$
		   	DISPLAYNAME, rescontainer.getString("insetsDN"),				 //$NON-NLS-1$
	      	// SHORTDESCRIPTION, "Get the insets for the container",	      	
	      	EXPERT, Boolean.TRUE 
	    		}
	    	),
			// layout
			super.createPropertyDescriptor(getBeanClass(), "layout", new Object[] {//$NON-NLS-1$
		   	DISPLAYNAME, rescontainer.getString("layoutDN"),				 //$NON-NLS-1$
	      	// SHORTDESCRIPTION, "Layout for container",
	    		}
	    	),
			// maximumSize
			super.createPropertyDescriptor(getBeanClass(), "maximumSize", new Object[] {//$NON-NLS-1$
		   	DISPLAYNAME, rescontainer.getString("maximumSizeDN"),				 //$NON-NLS-1$
	      	// SHORTDESCRIPTION, "Get maximum size of container",
	    		}
	    	),
			// minimumSize
			super.createPropertyDescriptor(getBeanClass(), "minimumSize", new Object[] {//$NON-NLS-1$
		   	DISPLAYNAME, rescontainer.getString("minimumSizeDN"),				 //$NON-NLS-1$
	      	// SHORTDESCRIPTION, "Get minimum size of container",
	    		}
	    	),
			// preferredSize
			super.createPropertyDescriptor(getBeanClass(), "preferredSize", new Object[] {//$NON-NLS-1$
		   	DISPLAYNAME, rescontainer.getString("preferredSizeDN"),				 //$NON-NLS-1$
	      	// SHORTDESCRIPTION, "Get preferred size of container",
	    		}
	    	),
		};
		return aDescriptorList;
	} catch (Throwable exception) {
		handleException(exception);
	};
	return null;
}
}
